<?php
declare(strict_types=1);
require __DIR__ . '/inc/bootstrap.php';
require __DIR__ . '/inc/layout.php';
require_login();

page_header(t('dashboard'));

$stats = [
  'stations' => (int)db()->query("SELECT COUNT(*) c FROM radio_stations")->fetch()['c'],
  'cats'     => (int)db()->query("SELECT COUNT(*) c FROM adhkar_categories")->fetch()['c'],
  'items'    => (int)db()->query("SELECT COUNT(*) c FROM adhkar_items")->fetch()['c'],
  'version'  => (int)db()->query("SELECT version FROM app_config WHERE id=1")->fetch()['version'],
];
?>
<div class="grid">
  <div class="card">
    <h3 style="margin-top:0"><?=h(t('system_status'))?></h3>
    <p><?=h(t('config_version'))?>: <span class="badge"><?=h((string)$stats['version'])?></span></p>
    <p class="muted"><?=h(t('tip_text'))?></p>
  </div>
  <div class="card">
    <h3 style="margin-top:0"><?=h(t('stats'))?></h3>
    <p><?=h(t('stations'))?>: <span class="badge"><?=h((string)$stats['stations'])?></span></p>
    <p><?=h(t('cats'))?>: <span class="badge"><?=h((string)$stats['cats'])?></span></p>
    <p><?=h(t('items'))?>: <span class="badge"><?=h((string)$stats['items'])?></span></p>
  </div>
</div>

<div class="card">
  <h3 style="margin-top:0"><?=h(t('quick_links'))?></h3>
  <div class="row">
    <a class="btn2" href="radio.php"><?=h(t('radio'))?></a>
    <a class="btn2" href="adhkar.php"><?=h(t('adhkar'))?></a>
    <a class="btn2" href="config.php"><?=h(t('config'))?></a>
  </div>
</div>
<?php page_footer(); ?>
