<?php
declare(strict_types=1);

function json_response($data, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

function method(): string {
  return strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET');
}

function route_path(): string {
  $uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
  // assumes this folder is mounted as /api
  $p = preg_replace('#^/api#', '', $uri);
  $p = rtrim($p ?: '/', '/');
  return $p === '' ? '/' : $p;
}

function allow_options(): void {
  if (method() === 'OPTIONS') {
    header('Access-Control-Max-Age: 86400');
    json_response(['ok' => true], 200);
  }
}
