<?php
declare(strict_types=1);

require __DIR__ . '/helpers.php';
require __DIR__ . '/db.php';

allow_options();

$path = route_path();
$m = method();

try {
  if ($m !== 'GET') {
    json_response(['error' => 'method_not_allowed'], 405);
  }

  if ($path === '/health') {
    json_response(['ok' => true, 'time' => gmdate('c')]);
  }

  if ($path === '/config') {
    $stmt = db()->query("SELECT config_json, version FROM app_config WHERE id=1 LIMIT 1");
    $row = $stmt->fetch();
    if (!$row) json_response(['error' => 'config_not_found'], 404);

    $cfg = json_decode((string)$row['config_json'], true);
    if (!is_array($cfg)) $cfg = [];

    json_response([
      'version' => (int)$row['version'],
      'config' => $cfg,
    ]);
  }

  if ($path === '/radio') {
    $stmt = db()->query("SELECT id, name, stream_url, is_default, is_active
                         FROM radio_stations
                         WHERE is_active=1
                         ORDER BY is_default DESC, id ASC");
    json_response(['stations' => $stmt->fetchAll()]);
  }

  if ($path === '/adhkar/categories') {
    $stmt = db()->query("SELECT id, name_ar, sort
                         FROM adhkar_categories
                         WHERE is_active=1
                         ORDER BY sort ASC, id ASC");
    json_response(['categories' => $stmt->fetchAll()]);
  }

  if ($path === '/adhkar/items') {
    $cat = isset($_GET['category_id']) ? (int)$_GET['category_id'] : 0;
    if ($cat <= 0) json_response(['error' => 'category_id_required'], 400);

    $stmt = db()->prepare("SELECT id, title_ar, text_ar, repeat_count, source, sort
                           FROM adhkar_items
                           WHERE is_active=1 AND category_id=?
                           ORDER BY sort ASC, id ASC");
    $stmt->execute([$cat]);
    json_response(['items' => $stmt->fetchAll()]);
  }

  json_response(['error' => 'not_found', 'path' => $path], 404);

} catch (Throwable $e) {
  json_response(['error' => 'server_error', 'message' => $e->getMessage()], 500);
}
